# 퓬`h
# Author:: fukuyama
# Date:: 2007/08/24
# Copyright:: Copyright (C) 2005-2007 rgss-lib

# ûɁv̂`h
#
# o[玡lɓw͂
class Life_Importantly < Rule_AI_Base
  
  # ̗̓x  ȉ̂goɂȂƉ񕜂悤Ƃ
  HP_LABEL = ['m','d','','y','']
  # ̗̓xɑΉgo̊  fɂ̓t@W[𗘗p
  HP_VALUE = [0.2,0.4,0.6,0.8,1.0]
  
  #   
  def initialize(name)
    super(name)
    # P̉
    add_rule(:recover_single_condition,:recover_single_action)
    # S̉
    add_rule(:recover_all_condition,:recover_all_action)
    # ftHg
    add_rule(:default_condition,:default_action)
    # t@W[f[^
    @partner_fuzzy_data_list = []
    # S̉񕜃XL
    @recover_all_skill_list = []
    # P̉񕜃XL
    @recover_single_skill_list = []
    # gp҉񕜃XL
    @recover_self_skill_list = []
  end
  
  # ANV쐬
  def make_action_initialize
    skill_initialize
    fuzzy_initialize
  end
  
  # gpXL
  def skill_initialize
    @recover_all_skill_list.clear
    @recover_single_skill_list.clear
    @recover_self_skill_list.clear
    
    # 퓬ɎgpłXL
    skill_list = Skill_Facade.actor_battle_skills(battler)
    # RXgɃ\[g
    skill_list.sort! { |a,b| a.sp_cost <=> b.sp_cost }
    skill_list.each do |skill|
      # gpłȂ̂͌₩폜
      next if not battler.skill_can_use?(skill.id)
      if skill.scope_friend? and skill.recover_skill? and (not skill.scope_hp0?)
        if skill.scope_all?
          @recover_all_skill_list.push skill
        elsif skill.scope_self?
          @recover_self_skill_list.push skill
        elsif skill.scope_single?
          @recover_single_skill_list.push skill
        end
      end
    end
  end
  
  # t@W[f[^
  def fuzzy_initialize
    @partner_fuzzy_data_list.clear
    for partner in partners
      next if partner.dead?
      fd = FuzzyData.new(partner)
      fd.create_fuzzy_set('̗',HP_LABEL,HP_VALUE,partner.hp) do |b,l,v|
        b.maxhp * v
      end
      @partner_fuzzy_data_list.push fd
    end
  end
  
  # t@W[f[^擾
  def get_fuzzy_data(key,data)
    fuzzy_data_list = []
    for fuzzy_data in @partner_fuzzy_data_list
      if fuzzy_data.match?(key,data)
        fuzzy_data_list.push fuzzy_data
      end
    end
    return fuzzy_data_list
  end
  
  def create_recover_target_score(target_battlers)
    # 񕜑Ώۃt@W[}gNX
    pdef_total = 0
    mdef_total = 0
    target_battlers.each do |b|
      pdef_total += b.pdef
      mdef_total += b.mdef
    end
    pdef_average = pdef_total / target_battlers.size
    mdef_average = mdef_total / target_battlers.size
    fs1 = createAverageFuzzySet(pdef_average)
    fs2 = createAverageFuzzySet(mdef_average)
    
    score_list = []
    for b in target_battlers
      fs_list = []
      fs_list.push createMaxFuzzySet(b.maxhp)
      fs_list.push fs1
      fs_list.push fs2
      fm = FuzzyMatrix.new(fs_list)
      score_list.push fm.score(b.hp,b.pdef,b.mdef)
    end
    return score_list
  end
  
  # 񕜂lȂꍇ
  def default_condition
    return 0.1
  end
  def default_action
    # |₷߂
    s = create_score_hp_pdef(targets)
    # _P̑IiXRÄԒႢj
    t = get_single_target_min(targets,s)
    # ʏU
    setup_normal_attack(t)
  end
  
  # XL񕜗ʌvZ
  def skill_recover(target,actor,skill)
    unless skill.recover_skill?
      return 0
    end
    recover = skill_damage(target,actor,skill).abs
    damage = target.maxhp - target.hp
    if (damage - recover) < 0
      return damage
    end
    return recover
  end
  
  def find_recover_skill(target,recover_skill_list)
    recover_skill = nil
    recover_score = 0
    for skill in recover_skill_list
      score = skill_recover(target,battler,skill)
      if recover_score < score
        if recover_skill.nil? or recover_skill.sp_cost > skill.sp_cost
          recover_skill = skill
        end
      end
    end
    return recover_skill
  end
  
  # P̉
  def recover_single_condition
    # P̂Ŝ̃XLȂP̂D悵ĉ
    if @recover_single_skill_list.empty? and @recover_all_skill_list.empty?
      return 0.0
    end
    fuzzy_data_list = get_fuzzy_data('̗',['m','d',''])
    if fuzzy_data_list.empty?
      return 0.0
    end
    list = []
    for fuzzy_data in fuzzy_data_list
      f1 = fuzzy_data['̗','m']
      f2 = fuzzy_data['̗','d']
      f3 = fuzzy_data['̗','']
      list.push((f1 * 1.0 + f2 * 0.8 + f3 * 0.6) / (f1 + f2 + f3) / 3)
    end
    return Fuzzy.or(*list)
  end
  def recover_single_action
    fuzzy_data_list = get_fuzzy_data('̗',['m','d',''])
    battler_list = []
    for fuzzy_data in fuzzy_data_list
      battler_list.push fuzzy_data.source
    end
    score_list = create_recover_target_score(battler_list)
    target = get_single_target_min(battler_list,score_list)
    
    recover_skill = find_recover_skill(target,@recover_single_skill_list)
    if recover_skill.nil?
      recover_skill = find_recover_skill(target,@recover_all_skill_list)
    end
    if recover_skill.nil?
      default_action()
    else
      setup_skill(recover_skill,target)
    end
  end
  
  # S̉
  def recover_all_condition
    if @recover_all_skill_list.empty?
      return 0.0
    end
    fuzzy_data_list = get_fuzzy_data('̗',['m','d',''])
    if fuzzy_data_list.size < (partners.size / 2.0).ceil
      return 0.0
    end
    list = []
    for fuzzy_data in fuzzy_data_list
      f1 = fuzzy_data['̗','m']
      f2 = fuzzy_data['̗','d']
      f3 = fuzzy_data['̗','']
      list.push((f1 * 0.9 + f2 * 0.9 + f3 * 0.9) / (f1 + f2 + f3) / 3)
    end
    return Fuzzy.and(*list)
  end
  def recover_all_action
    fuzzy_data_list = get_fuzzy_data('̗',['m','d',''])
    battler_list = []
    for fuzzy_data in fuzzy_data_list
      battler_list.push fuzzy_data.source
    end
    score_list = create_recover_target_score(battler_list)
    target = get_single_target_min(battler_list,score_list)
    recover_skill = find_recover_skill(target,@recover_all_skill_list)
    if recover_skill.nil?
      default_action()
    else
      setup_skill(recover_skill,target)
    end
  end
end
